#include "bullet.h"
#include "constants.h"

Bullet::Bullet()
{
	bActive = false;
}

/** @brief Moves the bullet.
  *
  * @param timediff Time since last step.
  * @return true if the bullet lives on, false if it is too old and should be
  *         destroyed.
  */
bool Bullet::move(int timediff)
{
	age += timediff;
	if ( age > BULLET_MAX_AGE )
		return false;

	position = position + (direction*(float)timediff*BULLET_VELOCITY);

	return true;
}

/** @brief Sends the bullet on its way.
  *
  * @param pos The initial position. This should be near, but not directly on,
  *            the position of the object that fired the bullet, because else
  *            it could be possible that the object gets hit by just this.
  *            (Although right now the collision detection routines should
  *            prevent this.)
  * @param dir The bullet's flying direction.
  * @param iModel The model used for drawing the bullet. Note that this is also
  *               used to distinguish between a 'normal' and 'extra fire power'
  *               bullet.
  */
void Bullet::start(Vector3D pos, Vector3D dir, int iModel)
{
	position = pos;
	direction = dir;
	bActive = true;
	model = iModel;
	age = 0;
}

