/** @file bullet.h
  * @brief Bullet declaration.
  */

#ifndef bullet_include
#define bullet_include

#include "vector3d.h"

/** @brief A bullet.
  *
  * This class is here only to avoid using a SpaceObject for an object with such
  * little requirements. A bullet only moves in one direction with a constant
  * velocity.
  * @todo Re-design SpaceObject and others into a hierarchy.
  */
class Bullet
{
public:
	/*constructor*/			Bullet();
	bool					move(int timediff);
	inline Vector3D			getPosition() const { return position; };
	inline int				getModel() const { return model; };
	inline bool				isActive() const { return bActive; };
	inline void				stop() { bActive = false; };
	void					start(Vector3D pos, Vector3D dir, int iModel);
protected:
	Vector3D				position,
							direction;
	int						age;
	bool					bActive;
	int						model;
};

#endif
