#include <cstdlib>
#include <iostream>
#include <cmath>
#include "commanderai.h"
#include "stdinclu.h"
#include "constants.h"
#include "spaceobject.h"

CommanderAI::CommanderAI(SpaceObject* pprnt)
{
	pParent = pprnt;			// keep track of my parent space object
	pParent->collectedMissiles(); // TODO can we handle this some other way?
	pParent->setShield(COMMANDER_SHIELD_STRENGTH);
	state = COM_APPROACH_POD;		// commander first destroys a pod
	pTarget = pPlayer = NULL;	// aim for player
	pTargetPod = NULL;
	maxvelocity = COMMANDER_MAX_VELOCITY;
	velocity = 100;
	turnspeed = COMMANDER_TURN_SPEED;
}

/**
  * Sets the targets of this AI.
  * @param pplr Pointer to the player space object.
  * @param ppod Pointer to the pod to be attacked.
  */
void CommanderAI::setInitialTargets(SpaceObject* pplr, SpaceObject* ppod)
{
	pPlayer = pplr;
	pTarget = pTargetPod = ppod;
}

void CommanderAI::step(int timediff)
{
	static Vector3D		distance;	// between me and my target
	Vector3D			tmpv;
	switch (state)
	{
		case COM_APPROACH_POD:
			trackTarget(timediff);
			distance = pTargetPod->getPosition() - pParent->getPosition();
			if ( distance.getLength() < COMMANDER_BRAKE_DISTANCE )
			{// fly slower in vicinity of pod
				velocity = COMMANDER_APPROACH_VELOCITY;
				state = COM_ATTACK_POD;
			}
			break;
		case COM_ATTACK_POD:
			trackTarget(timediff);
			distance = pTargetPod->getPosition() - pParent->getPosition();
			if ( distance.getLength() < COMMANDER_DESTRUCT_DISTANCE )
			{
				pTargetPod->setSelfDestruction();
				velocity = 100;
				state = COM_ATTACK_PLAYER;
				pTarget = pPlayer;
			}
			break;
		case COM_ATTACK_PLAYER:
			trackTarget(timediff);
			distance = pTarget->getPosition() - pParent->getPosition();
			if (distance.getLength() <= COMMANDER_FIRE_DISTANCE)
				if ( DEGREES(acos(DotProduct(distance, pParent->getLookDir()) / (distance.getLength()) )) < 3 )
					pParent->shoot();
			if (distance.getLength() <= COMMANDER_STOPFIRE_DISTANCE)
			{
				setTargetPosition((pParent->getPosition()-pTarget->getPosition())*10000);
				state = COM_FLEE;
			}
			break;
		case COM_FLEE:
			break;
	}
}

