/** @file commanderai.h
  * @brief CommanderAI declaration.
  */

#ifndef commanderai_include
#define commanderai_include

#include "shipai.h"
#include "podai.h"

class SpaceObject;

enum CommanderState { COM_APPROACH_POD, COM_ATTACK_POD, COM_ATTACK_PLAYER, COM_FLEE };

/** @brief Commander Ship AI.
  *
  * This AI is the one that is least carefully implemented. It currently
  * attacks a pod and the player.
  */
class CommanderAI: public ShipAI
{
	// overridden base class methods
	virtual void		step(int timediff);
public:
						CommanderAI(SpaceObject*);	// constructor
	void				setInitialTargets(SpaceObject*, SpaceObject*);
	inline SpaceObject*	getTargetPod() const { return pTargetPod; }
private:
	CommanderState		state;
	SpaceObject*		pTargetPod;
	SpaceObject*		pPlayer;
	PodAI*				pTargetAI;
};

#endif
