/** @file configuration.h
  * @brief Configuration declaration.
  */

#ifndef configuration_include
#define configuration_include

enum HUD_TYPE { HUD_NETWARS=0, HUD_ADV_NETWARS=1 };

const HUD_TYPE DEFAULT_HUD_TYPE = HUD_NETWARS;

// configuration constants
const int DEFAULT_NUM_STARS =	5000;
const bool DEFAULT_FULLSCREEN =	false;
const int DEFAULT_WIDTH =		640;
const int DEFAULT_HEIGHT =		480;
#define CONFIG_FILENAME			"nwconfig"
#define CONFIG_HUDTYPE			"hud_type"
#define CONFIG_NUMSTARS			"num_stars"
#define CONFIG_FULLSCREEN		"fullscreen"
#define CONFIG_WIDTH			"window_width"
#define CONFIG_HEIGHT			"window_height"

/** @brief The game configuration management (saving and loading).
  *
  * It simply keeps global game settings and is intended to be used as one 
  * global object only, so every other object may have access and change the
  * configuration.
  */
class Configuration 
{
public:
					Configuration();
	inline void		setNumStars(int num) { numStars = num; }
	inline int		getNumStars() const { return numStars; }
	inline void		setHUDType(HUD_TYPE t) { hudType = t; }
	inline HUD_TYPE	getHUDType() const { return hudType; }
	inline void		setFullScreen(bool fs) { fullscreen = fs; }
	inline bool		isFullScreen() const { return fullscreen; }
	inline void		setWidth(int w) { width = w; }
	inline int		getWidth() const { return width; }
	inline void		setHeight(int h) { height = h; }
	inline int		getHeight() const { return height; }
	void			load();
	void			save();

private:
	void			setDefaults();
	void			getFileName(char*);

	int				numStars;	///< number of stars
	HUD_TYPE		hudType;	///< HUD type identifier
	bool			fullscreen;	///< true indicates full screen viewing
	int				width;		///< non-fullscreen width
	int				height;		///< non-fullscreen height
};

#endif

