/** @file constants.h
  * @brief NetWarsGL game specific constants.
  *
  * This includes timing, sizes and strings.
  */

#ifndef constants_include
#define constants_include

//#define PI				3.1415926535897932384626433832795
#define RAD90				1.57079632679489661923132169163975f
/// convert radians to degrees:
#define DEGREES(x)			((float)(x*57.2957795130823208767981548141052f))
/// convert degrees to radians:
#define RADIANS(x)			(x/57.2957795130823208767981548141052f)


#define SHIP_RADIUS			96
#define MAX_VELOCITY		1.5/*0.012*/

// power up constants
#define CLOAK_DRAIN_SPEED	0.01
#define THRUST_DRAIN_SPEED	0.005
#define THRUST_FACTOR		2
#define PODPOS				300
#define POWERUP_RADIUS		96

// particle system constants
#define MAX_PARTICLES			100
#define PARTICLE_MIN_VELOCITY	0.66f/*0.01f*/
#define PARTICLE_RADIUS			20.0f/*0.3f*/

// bullet constants
#define	BULLET_VELOCITY		((float)MAX_VELOCITY*8.0f)
#define BULLET_MAX_AGE		1500
#define BULLET_RADIUS		30
#define PLAYER_BULLET_INTERVAL		100
#define BULLET_POWER		1

// missile constants
#define MAX_MISSILES		20
#define MISSILE_VELOCITY	((float)MAX_VELOCITY*THRUST_FACTOR*1.5)
#define MISSILE_RADIUS		BULLET_RADIUS
#define MISSILE_MAX_AGE		30000
#define MISSILE_INTERVAL	200
#define MISSILE_TURN_SPEED	0.2
#define MISSILE_POWER		10
#define MISSILE_DISPLACEMENT	500

// MAX_BULLETS per ship
#define MAX_BULLETS			(BULLET_MAX_AGE / PLAYER_BULLET_INTERVAL)

// game space constants
#define NUM_STARS			1000
#define MAX_POWERUPS		20
#define MAX_SHIPS			80
#define MAX_PARTICLESYSTEMS	(MAX_POWERUPS + MAX_SHIPS)
#define MOUSE_DEADZONE		6	// in pixels
#define MOUSE_SENSITIVITY	0.2	// 1 = rotation per ms equals mouse position offset from screen center

// HUD constants
#define RADARWIDTH			0.1	// fraction of screen width
#define MESSAGE_VISIB_TC	1000	// for how long a message is visible on screen
#define MESSAGE_YCOORD		(giHeight*0.8)
#define SHOW_GAMEOVER		4000 // for how long the 'Game Over' is visible
#define GAMEOVER_TEXT		"GAME OVER"
#define ADNW_SHIELDS		"Shields"
#define ADNW_THRUSTERS		"Thrusters"
#define ADNW_OFF			"Off"
#define ADNW_FORWARD		"Forward"
#define ADNW_REVERSE		"Reverse"
#define ADNW_SHELLS			"Shells:"
#define ADNW_MISSILES		"Missiles:"
#define ADNW_CLOAK			"Cloaking Device:"
#define ADNW_TURBO			"Turbo Thruster:"

// pirate AI constants
#define PIRATE_SPAWN_DISTANCE	7000
#define PIRATE_MISSILE_DISTANCE	4500
#define PIRATE_FLEE_DISTANCE	6000
#define PIRATE_MAX_VELOCITY		(MAX_VELOCITY*0.8)
#define PIRATE_TURN_SPEED		0.07
#define PIRATE_SHIELD_STRENGTH	(2*BULLET_POWER)
#define PIRATE_BRAKE_DISTANCE	800
#define PIRATE_APPROACH_VELOCITY	30
#define PIRATE_DOCK_DISTANCE	(2*SHIP_RADIUS)
#define PIRATE_DESTRUCTION_DISTANCE		10000
#define PIRATE_DESTRUCTION_TIME	20000

// fighter AI constants
#define FIGHTER_SPAWN_DISTANCE	PIRATE_SPAWN_DISTANCE
#define FIGHTER_FIRE_DISTANCE	3500
#define FIGHTER_STOPFIRE_DISTANCE	600
#define FIGHTER_FLEE_DISTANCE	4000
#define FIGHTER_MAX_VELOCITY	(MAX_VELOCITY)
#define FIGHTER_TURN_SPEED		PIRATE_TURN_SPEED
#define FIGHTER_SHIELD_STRENGTH	(2*BULLET_POWER) 
#define FIGHTER_BULLET_INTERVAL	200

// guardian AI constants
#define GUARDIAN_SPAWN_DISTANCE	PIRATE_SPAWN_DISTANCE
#define GUARDIAN_STOP_DISTANCE	(8*SHIP_RADIUS)
#define GUARDIAN_FIRE_DISTANCE	3500
#define GUARDIAN_MAX_VELOCITY	(MAX_VELOCITY*1.4)
#define GUARDIAN_TURN_SPEED		(PIRATE_TURN_SPEED*1.33)
#define GUARDIAN_SHIELD_STRENGTH	(4*BULLET_POWER)
#define GUARDIAN_BULLET_INTERVAL	150

// commander AI constants
#define COMMANDER_SPAWN_DISTANCE	PIRATE_SPAWN_DISTANCE
#define COMMANDER_MAX_VELOCITY		(MAX_VELOCITY*1.1)
#define COMMANDER_TURN_SPEED		(PIRATE_TURN_SPEED*1.33)
#define COMMANDER_SHIELD_STRENGTH	(8*BULLET_POWER)
#define COMMANDER_BRAKE_DISTANCE	6*SHIP_RADIUS
#define COMMANDER_APPROACH_VELOCITY	30
#define COMMANDER_DESTRUCT_DISTANCE	0.5*SHIP_RADIUS
#define COMMANDER_FIRE_DISTANCE		3500
#define COMMANDER_STOPFIRE_DISTANCE	600
#define COMMANDER_BULLET_INTERVAL	150

// pod (AI) constants
#define POD_POSITION_TOLERANCE	10
#define POD_AUTOROTATION		0.18, 0.18, 0
#define POD_RETURN_VELOCITY		30

// menu constants
#define MAINMENU_Y0				((int)(giHeight*0.25))
#define MAINMENU_ITEM_DISTANCE	16
#define MAIN_SPMODE_TEXT		"Single Player Mode"
#define MAIN_MPMODE_TEXT		"Multi Player Mode"
#define MAIN_HIGHSCORE_TEXT		"High Score Table"
#define MAIN_OPTIONS_TEXT		"Options"
#define MAIN_QUIT_TEXT			"Quit"
#define MAIN_VERSION_TEXT		"version 0.4, written by Ingmar Frank 2003, 2004"
#define MAIN_CONTACT_TEXT		"Visit http://www.mininova.de/netwars - e-mail to netwarsgl@mininova.de"

#define OPTIONS_Y0				((int)(giHeight*0.4))
#define OPTIONS_ITEM_DISTANCE	MAINMENU_ITEM_DISTANCE
#define OPTIONS_TITLE_TEXT		"Options"
#define OPTIONS_STARS_TEXT		"Number of stars: "
#define OPTIONS_HUD_TEXT		"HUD type: "
#define OPTIONS_HUD_NW			"NetWars"
#define OPTIONS_HUD_ADNW		"Advanced NetWars"
#define OPTIONS_FULLSCREEN_TEXT	"fullscreen: "
#define OPTIONS_FULLSCREEN_ON	"on"
#define OPTIONS_FULLSCREEN_OFF	"off"
#define OPTIONS_BACK_TEXT		"back to main menu"

#define LEVEL_CONTINUE_TEXT		"continue"

#define INFO_PODS_TEXT			"PROTECT PODS"
#define INFO_ALIENS_TEXT 		"DESTROY ALIENS"
#define INFO_SATS_TEXT			"COLLECT SATELLITES"
#define INFO_START_TEXT			"click here or press ENTER or SPACE to start"
#define INFO_PIRATE				"Pirate"
#define INFO_FIGHTER			"Fighter"
#define INFO_GUARDIAN			"Guardian"
#define INFO_COMMANDER			"Commander"
#define INFO_SHIELD				"Extra SHIELD"
#define	INFO_MISSILES			"Extra MISSILES"
#define INFO_THRUST				"Extra THRUST"
#define INFO_FIREPOWER			"Extra FIREPOWER"

// multi player menu
#define MP_JOIN_TEXT			"join a game"
#define MP_HOST_TEXT			"start a new game as host"
#define MP_BACK_TEXT			"return to main menu"

// scores
#define SCORE_MISSILE			25
#define SCORE_ALIEN				100
#define POD_BONUS_MULT			1000

// level and event constants
#define LEVELCOUNT				8
#define LEVEL_OVER_PLAY			6000
#define MAX_ALIENEVENTS			32

// highscore constants
const int HS_NAME_LENGTH =		20;
const unsigned int HS_ENTRY_COUNT =	10;
#define HS_CONGRATS_TEXT		"Congratulations!"
#define HS_ENTERNAME_TEXT		"Please enter your name:"
#define HS_NAME_ANONYMOUS		"Anonymous"
#define HS_FILENAME				"scores"
#define HS_TITLE				"High Score Table"
#define HS_CONTINUE				"click to continue"

/////// OpenGL colors
#define GLBLACK			0.0, 0.0, 0.0
#define GLWHITE			1.0, 1.0, 1.0
#define GLGREY			0.5, 0.5, 0.5
#define GLRED			1.0, 0.0, 0.0
#define GLDARK_RED		0.7, 0.0, 0.0
#define GLGREEN			0.0, 1.0, 0.0
#define GLDARK_GREEN	0.0, 0.7, 0.0
#define GLBLUE			0.0, 0.0, 1.0
#define GLDARK_BLUE		0.0, 0.0, 0.7
#define GLYELLOW		1.0, 1.0, 0.0
#define GLMAGENTA		1.0, 0.0, 1.0
#define GLCYAN			0.0, 1.0, 1.0
#define GLPURPLE		1.0, 0.14, 0.66
#define GLDARK_PURPLE	0.5, 0.07, 0.33

// The value of MAX_BULLETS is potentially dangerous. We assume that the
// player will always be the one with the highest firing frequency, so we
// should be fine using this value for the maximum number of bullets per ship.
// But just to make sure, check it:
#if ( FIGHTER_BULLET_INTERVAL < PLAYER_BULLET_INTERVAL )
	#error PLAYER_BULLET_INTERVAL is not the minimum value
#endif

#if ( GUARDIAN_BULLET_INTERVAL < PLAYER_BULLET_INTERVAL )
	#error PLAYER_BULLET_INTERVAL is not the minimum value
#endif

#if ( COMMANDER_BULLET_INTERVAL < PLAYER_BULLET_INTERVAL )
	#error PLAYER_BULLET_INTERVAL is not the minimum value
#endif

#endif 

