#include <GL/glut.h>
#include <string.h>
#include <ctype.h>
#include "text.h"
#include "entername.h"

extern int giWidth, giHeight, giWidthHalf, giHeightHalf;

EnterName::EnterName()
{
	reset();
}

/** @brief Resets all relevant members to start values.
  *
  * After calling this method, no name is entered and the ready flag is
  * not set.
  */
void EnterName::reset()
{
	name = "_";//strcpy(name, "_");
	name.resize(HS_NAME_LENGTH);
	index = 0;
	//index = name.begin();
	ready = false;
}

void EnterName::reshapeFunc()
{
}

void EnterName::displayFunc()
{
	glClearColor(0, 0, 0, 0);
	glClearDepth(1.0);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glPushAttrib(GL_LIGHTING_BIT);
	glDisable(GL_LIGHTING);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
		glLoadIdentity();
		gluOrtho2D(0, giWidth, 0, giHeight);
		glColor3f(GLGREEN);
		Text::printCenteredAt(giWidthHalf, giHeightHalf + 50, HS_CONGRATS_TEXT);
		Text::printCenteredAt(giWidthHalf, giHeightHalf + 25, HS_ENTERNAME_TEXT);
		glColor3f(GLWHITE);
		Text::printCenteredAt(giWidthHalf, giHeightHalf     , name.c_str());
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopAttrib();

	glutSwapBuffers();
}

void EnterName::mouseFunc(int button, int state, int x, int y)
{
}

void EnterName::mouseMotionFunc(int x, int y)
{
}

/** @brief Handles name input.
  *
  * In this special case, the keyboardFunc() is the most important one.
  * Key presses are added to the name if they are printable characters.
  * The underscore character _ serves as the cursor.
  * Backspace deletes the last character. The Return (Enter) key strips the
  * underscore character and sets the name to a generic one if nothing was
  * entered. After this, the ready flag is set so a user of an object of this
  * class can see that the input has ended.
  *
  * @todo Do we need in-string navigation (cursor keys left-right)?
  */
void EnterName::keyboardFunc(unsigned char key, int x, int y)
{
	if ( isprint(key) && (index < HS_NAME_LENGTH-2) )
	{
		name[index++] = key;
		name[index] = '_';
	}
	else if ( key==8 && (index > 0) )
	{// backspace
		name[index--] = '\0';
		name[index] = '_';
	}
	else if ( key==13 )
	{// return
		if ( index==0 )
			name = HS_NAME_ANONYMOUS;//strcpy(name, HS_NAME_ANONYMOUS);
		else
			name[index] = '\0'; // overwrite the _
		ready = true;
	}
	glutPostRedisplay();
}

void EnterName::specialFunc(int key, int x, int y)
{
}

void EnterName::specialUpFunc(int key, int x, int y)
{
}

void EnterName::keyboardUpFunc(unsigned char key, int x, int y)
{
}

void EnterName::idleFunc()
{
}

