/** @file entername.h
  * @brief EnterName declaration.
  */

#ifndef entername_include
#define entername_include

#include <string>
#include "iglut.h"
#include "constants.h"

/** @brief The 'enter your name' screen.
  *
  */
class EnterName : public IGlut
{
public:
	EnterName();
	virtual ~EnterName() {};

	/** @returns true if the user has finished typing his/her name by pressing
	  * RETURN.
	  */
	inline bool			isReady() const { return ready; }

	/** @returns The name that was typed by the user, or a generic name
	  * (like 'anonymous') if nothing was entered. This method should only
	  * be called if isReady() returns true.
	  */
	inline std::string	getName() const { return name; }
	//inline char*		getName() { return name; }

	// IGlut implementation
	virtual void		reshapeFunc();
	virtual void		displayFunc();
	virtual void		mouseFunc(int button, int state, int x, int y);
	virtual void		mouseMotionFunc(int x, int y);
	virtual void		keyboardFunc(unsigned char key, int x, int y);
	virtual void		keyboardUpFunc(unsigned char key, int x, int y);
	virtual void		specialFunc(int key, int x, int y);
	virtual void		specialUpFunc(int key, int x, int y);
	virtual void		idleFunc();
private:
	void				reset();

	std::string			name;//[HS_NAME_LENGTH];	///< The name being entered.
	//unsigned short		index;	///< The current index (cursor position).
	unsigned int		index;	///< The current index (cursor position).
	bool				ready;	///< Indicates whether the user pressed RETURN.
};

#endif
