#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "stdinclu.h"
#include "constants.h"
#include "shipai.h"
#include "spaceobject.h"
#include "fighterai.h"
#include "game.h"

/*
*/

FighterAI::FighterAI(SpaceObject* pprnt)
{
	pParent = pprnt;			// keep track of my parent space object
	pParent->collectedMissiles(); // TODO can we handle this some other way?
	pParent->setShield(FIGHTER_SHIELD_STRENGTH);
	state = FIGHTER_ATTACK;		// fighter always attacks player
	pTarget = pPlayer = NULL;	// aim for player
	maxvelocity = FIGHTER_MAX_VELOCITY;
	velocity = 100;
	turnspeed = FIGHTER_TURN_SPEED;
}

void FighterAI::step(int timediff)
{
	static Vector3D		distance;	// between me and my target
	Vector3D			tmpv;
	switch (state)
	{
		case FIGHTER_ATTACK:	// try to fire at target
			trackTarget(timediff);	// turn and move towards target
			distance = pTarget->getPosition() - pParent->getPosition();
			if (distance.getLength() <= FIGHTER_FIRE_DISTANCE)
				if ( DEGREES(acos(DotProduct(distance, pParent->getLookDir()) / (distance.getLength()) )) < 3 )
					pParent->shoot();
			if (distance.getLength() <= FIGHTER_STOPFIRE_DISTANCE)
			{
				setTargetPosition((pParent->getPosition()-pTarget->getPosition())*10000);
				state = FIGHTER_FLEE;
			}
			break;
		case FIGHTER_FLEE: // try to get some distance
			setTargetPosition((pParent->getPosition()-pTarget->getPosition())*10000);
			moveToTarget(targetPos, timediff);
			distance = pTarget->getPosition() - pParent->getPosition();
			if (distance.getLength() > FIGHTER_FLEE_DISTANCE)
			{// aim at a pod and switch state
				state = FIGHTER_ATTACK;
			}
			break;
	}
}

