/** @file fighterai.h
  * @brief FighterAI declaration.
  */

#ifndef fighterai_include
#define fighterai_include

#include "shipai.h"

class SpaceObject;

enum FighterState { FIGHTER_ATTACK, FIGHTER_FLEE };

/** @brief Fighter Ship AI.
  *
  * This AI attacks the player with bullets.
  */
class FighterAI : public ShipAI
{
	// overridden base class methods
	virtual void		step(int timediff);
public:
						FighterAI(SpaceObject*);	// constructor
private:
	FighterState		state;
	SpaceObject*		pPlayer;
};

#endif

