#include <stdlib.h>
#include <cmath>
#include "constants.h"
#include "stdinclu.h"
#include "guardianai.h"
#include "spaceobject.h"

static Vector3D center(0, 0, 0);

GuardianAI::GuardianAI(SpaceObject* pprnt)
{
	pParent = pprnt;			// keep track of my parent space object
	pParent->collectedMissiles(); // TODO can we handle this some other way?
	pParent->setShield(GUARDIAN_SHIELD_STRENGTH);
	state = GUARDIAN_APPROACH;		// guardian approaches the pods
	pTarget = pPlayer = NULL;
	maxvelocity = GUARDIAN_MAX_VELOCITY;
	velocity = 100;
	turnspeed = GUARDIAN_TURN_SPEED;
}

void GuardianAI::step(int timediff)
{
	static Vector3D distance;

	switch (state)
	{
		case GUARDIAN_APPROACH:
			moveToTarget(center, timediff);
			distance = center - pParent->getPosition();
			if ( distance.getLength() <= GUARDIAN_STOP_DISTANCE )
			{
				velocity = 0;
				state = GUARDIAN_ATTACK;
			}
			break;
		case GUARDIAN_ATTACK:
			trackTarget(timediff);	// turn towards target
			distance = pTarget->getPosition() - pParent->getPosition();
			if ( distance.getLength() <= GUARDIAN_FIRE_DISTANCE )
				if ( DEGREES(acos(DotProduct(distance, pParent->getLookDir()) / (distance.getLength()) )) < 3 )
					pParent->shoot();
			break;
	}
}

