/** @file guardianai.h
  * @brief GuardianAI declaration.
  */

#ifndef guardianai_include
#define guardianai_include

#include "shipai.h"

class SpaceObject;

enum GuardianState { GUARDIAN_APPROACH, GUARDIAN_ATTACK };

/** @brief Guardian Ship AI.
  *
  * This AI approaches the pods, stays there and attacks the player's ship
  * if it is in firing range.
  */
class GuardianAI : public ShipAI
{
	// overridden base class methods
	virtual void		step(int timediff);
public:
						GuardianAI(SpaceObject*);	// constructor
private:
	GuardianState		state;
	SpaceObject*		pPlayer;
};

#endif
