/** @file highscore.h
  * @brief Highscore declaration.
  */

#ifndef highscore_include
#define highscore_include

#include <vector>
#include "constants.h"
#include "entername.h"
#include "menu.h"

/** @brief An entry in the high score table.
  */
struct HSEntry
{
	int			score;	///< The score for this entry.
	std::string	name;	///< The name for this entry.
};

typedef std::vector<HSEntry> entry_vector;

/** @brief High score table management and visualisation.
  *
  * Use an object of this class to load and save the high scores, to enter
  * new scores and to show them on screen.
  */
class Highscore
{
public:
	Highscore();
	virtual ~Highscore();

	void				load();
	void				save();
	void				insert(int, std::string);
	Menu*				getHSMenu();
	inline const EnterName*	getEnterName() { return &entername; }
	inline int			getMinimumScore() const { return entries[entries.size()-1].score; }

private:
	void				getFileName(char*);
	void				createHSMenu();

	entry_vector		entries;	///< The scores.
	EnterName			entername;	///< Enter your name.
	Menu*				phsmenu;	///< High score table visualisation.
};

#endif
