/** @file hitindicator.cpp
  * @brief Definition of HitIndicator.
  */

#include <cmath>
#include "constants.h"
#include "hitindicator.h"

bool HitIndicator::move(int timediff)
{
	age += timediff;
	if ( age >= HITINDICATOR_MAX_AGE )
		return false;

	radius += RADIUS_STEP * timediff;

	return true;
}

void HitIndicator::draw(const Vector3D& campos,
						const SpaceObject& obj)
{
	glPushAttrib(GL_ENABLE_BIT);
		glDisable(GL_LIGHTING);
		glColor3d(GLRED);
		glTranslatef(pos.x, pos.y, pos.z);

		// this is the hard way, but maybe faster 
		// than acos/CrossProduct/glRotate
		float m[16];
		m[ 0] = obj.getRight().x; m[ 4] = obj.getUp().x; m[ 8] = obj.getLookDir().x; m[12] = 0.0f;
		m[ 1] = obj.getRight().y; m[ 5] = obj.getUp().y; m[ 9] = obj.getLookDir().y; m[13] = 0.0f;
		m[ 2] = obj.getRight().z; m[ 6] = obj.getUp().z; m[10] = obj.getLookDir().z; m[14] = 0.0f;
		m[ 3] = 0;       m[ 7] = 0;    m[11] = 0;         m[15] = 1.0f;
		glMultMatrixf(m);

		glutSolidTorus(radius*0.1, radius, 12, 20);
	glPopAttrib();
}

