/** @file hitindicator.h
  * @brief HitIndicator declaration.
  */

#ifndef hitindicator_include
#define hitindicator_include

#include "vector3d.h"
#include "spaceobject.h"

#define HITINDICATOR_MAX_AGE 500
#define START_RADIUS         SHIP_RADIUS*0.1
#define RADIUS_STEP          ((SHIP_RADIUS - START_RADIUS)/(double)HITINDICATOR_MAX_AGE)

/** @brief A graphics effect to show that a weapon hit has occured.
  */
class HitIndicator
{
public:
	/* ctor */		HitIndicator(const Vector3D& pos) 
		: pos(pos), age(0), radius(START_RADIUS) {};
	bool move(int timediff);
	void draw(const Vector3D&, const SpaceObject&);

private:
	Vector3D			pos;		///< Position.
	int					age;		///< Age.
	double				radius;		///< Radius (torus effect).
};

#endif // hitindicator_include
