/** @file iglut.h
  * @brief IGlut declaration.
  */

#ifndef iglut_include
#define iglut_include

/** @brief An interface that every 'game state' (like the menu, game) implements.
  *
  * Since GLUT uses C functions as callbacks, there has to be some mechanism
  * to be able to have multiple handlers for key events, mouse movement, idle
  * processing and so on. By implementing this interface, a class may be some
  * kind of a 'current GLUT context'. The implemented methods then get called
  * by the global C callbacks.
  */
class IGlut
{
public:
	/// Gets called by glutReshapeFunc().
	virtual void		reshapeFunc() = 0;

	/// Gets called by glutDisplayFunc().
	virtual void		displayFunc() = 0;

	/// Gets called by glutMouseFunc().
	/** @param button Mouse button identifier.
	 * @param state Mouse button state.
	 * @param x The x coordinate of the mouse pointer.
	 * @param y The y coordinate of the mouse pointer.
	 */
	virtual void		mouseFunc(int button, int state, int x, int y) = 0;

	/// Gets called by glutMotionFunc() and glutPassiveMotionFunc().
	/** @param x The x coordinate of the mouse pointer.
	 * @param y The y coordinate of the mouse pointer.
	*/
	virtual void		mouseMotionFunc(int x, int y) = 0;

	/// Gets called by glutKeyboardFunc().
	/** @param key ASCII charakter.
	 * @param x The x coordinate of the mouse pointer.
	 * @param y The y coordinate of the mouse pointer.
	 */
	virtual void		keyboardFunc(unsigned char key, int x, int y) = 0;

	/// Gets called by glutKeyboardUpFunc(). 
	/** @param key ASCII charakter.
	 * @param x The x coordinate of the mouse pointer.
	 * @param y The y coordinate of the mouse pointer.
	 */
	virtual void		keyboardUpFunc(unsigned char key, int x, int y) = 0;

	/// Gets called by glutSpecialFunc(). 
	/** @param key Special key identifier.
	 * @param x The x coordinate of the mouse pointer.
	 * @param y The y coordinate of the mouse pointer.
	 */
	virtual void		specialFunc(int key, int x, int y) = 0;

	/// Gets called by glutSpecialUpFunc(). 
	/** @param key Special key identifier.
	 * @param x The x coordinate of the mouse pointer.
	 * @param y The y coordinate of the mouse pointer.
	 */
	virtual void		specialUpFunc(int key, int x, int y) = 0;

	/// Gets called by glutIdleFunc().
	virtual void		idleFunc() = 0;
};

#endif
