/** @file level.h
  * @brief Level declaration.
  */

#ifndef level_include
#define level_include

#include <vector>
#include "stdinclu.h"
#include "vector3d.h"

class Game;

/** @brief An event for spawning an object.
  *
  * The information required to spawn an object in the universe
  * is filled in here.
  */
typedef struct tagLEVELEVENT
{
	EventType		type;			///< What kind of object to spawn.
	EventPosType	postype;		///< What kind of positioning to use.
	PowerUpType		putype;			///< Type of power-up to be spawned.
	AIShipType		aitype;			///< Type of AI to be spawned.
	Vector3D		pos;			///< for absolute position only
	float			distance;		///< for relative position only
	int				time_offset;	///< since level start
	bool			processed;		///< true if the event has been processed, TODO: remove events from list
} LevelEvent;

/** @brief A single player game level.
  *
  * An object of this class serves as a level timing mechanism. It keeps track
  * of the alien ships and power-ups. It spawns those objects by processing
  * level events (see LevelEvent).
  */
class Level
{
public:
				Level();				/* constructor */
				Level(const Level&);	/* copy constructor to extend levels easily */
				~Level();				/* destructor */
	
	void		start(Game*);
	void		addEvent(const LevelEvent& event);
	void		step(int timediff);
	inline void	incAIkilledCount() { aikilledcount++; }

private:
	typedef std::vector<LevelEvent*> EventVector;
	typedef EventVector::iterator eventit;

	int			timeoffset;
	int			aieventcount;	// AI spawning event count
	int			aikilledcount;	// count of AIs that have been killed
	Game*		pGame;
	EventVector	events;
};

#endif

