#include "levelmanager.h"

const int MAX_AIPERLEVEL = 32;	// level 8: 4 types * 8 ships = 32
const int SPAWN_TIMEOFFSET = 4000;

/** @brief Stores information about the alien order in a level.
  */
typedef struct LEVELINFO
{
	int		eventcount;	///< The overall alien count.
	AIShipType		aitype[MAX_AIPERLEVEL]; ///< AI types in order of appearance.
} LevelInfo;

/** @brief The alien appearance order for every level, NetWars style.
  * @todo Campaign mechanics like NetWars?
  */
const LevelInfo levels[LEVELCOUNT] = {
	// level 0
	{ 8, { PIRATE, PIRATE, PIRATE, PIRATE, PIRATE, PIRATE, PIRATE, PIRATE }},
	// level 1
	{ 10, { PIRATE, FIGHTER, PIRATE, PIRATE, PIRATE, PIRATE, FIGHTER, PIRATE, PIRATE, PIRATE }},
	// level 2
	{ 14, { PIRATE, FIGHTER, GUARDIAN, PIRATE, FIGHTER, PIRATE, PIRATE, PIRATE, FIGHTER, GUARDIAN, PIRATE, FIGHTER, PIRATE, PIRATE }},
	// level 3
	{ 18, { PIRATE, FIGHTER, GUARDIAN, PIRATE, FIGHTER, GUARDIAN, PIRATE, FIGHTER, PIRATE, PIRATE, FIGHTER, GUARDIAN, PIRATE, FIGHTER, GUARDIAN, PIRATE, FIGHTER, PIRATE }},
	// level 4
	{ 24, { PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, PIRATE, FIGHTER, GUARDIAN, PIRATE, FIGHTER, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, PIRATE, FIGHTER, GUARDIAN, PIRATE, FIGHTER }},
	// level 5
	{ 28, { PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, PIRATE, FIGHTER, GUARDIAN, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, PIRATE, FIGHTER, GUARDIAN }},
	// level 6
	{ 30, { PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN }},
	// level 7
	{ 32, { PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, COMMANDER, PIRATE, FIGHTER, GUARDIAN, COMMANDER }},
};

LevelManager::LevelManager()
{
	current = 0;
	createLevels();
}

LevelManager::~LevelManager()
{
	for ( int i=0; i < LEVELCOUNT; i++ )
		delete plevels[i];
}

void LevelManager::createLevels()
{
	LevelEvent	event;
	int			postypeindex;

	event.type = SPAWN_AISHIP;
	event.distance = PIRATE_SPAWN_DISTANCE;
	event.processed = false;

	for ( int i=0; i<LEVELCOUNT; i++ )
	{
		plevels[i] = new Level();
		postypeindex = 0;
		event.time_offset = 0;
		for ( int k=0; k<levels[i].eventcount; k++ )
		{
			event.time_offset += SPAWN_TIMEOFFSET;
			event.aitype = levels[i].aitype[k];
			event.postype = EventPosOrder[postypeindex];
			plevels[i]->addEvent(event);

			postypeindex++;
			if ( EventPosOrder[postypeindex] == EVENTPOS_TYPE_COUNT )
				postypeindex = 0;
		}
	}
}

/** @brief Start the single player campaign.
  *
  * This resets the current level index to 0 (level 1).
  */
void LevelManager::start()
{
	current = 0;
}

Level* LevelManager::getCurrentLevel() const
{
	return plevels[current];
}

int LevelManager::getCurrentLevelNumber() const
{
	return current+1;
}

/** @brief Advances to the next level.
  *
  */
void LevelManager::nextLevel()
{
	current++;
	if ( current == LEVELCOUNT )
		current--;	// will restart the last level over and over
}

/** @brief Resets all levels.
  *
  * All levels are deleted and re-created. Use this between single player
  * games.
  */
void LevelManager::reset()
{
	for ( int i=0; i<LEVELCOUNT; i++ )
		delete plevels[i];
	createLevels();
	current = 0;
}

