/** @file levelmanager.h
  * @brief LevelManager declaration.
  */

#ifndef levelmanager_include
#define levelmanager_include

#include "constants.h"
#include "level.h"

/** @brief Manages level order for a single player game.
  *
  * Creates the levels with their events and manages their order in a
  * single player game.
  */
class LevelManager
{
public:
	LevelManager();
	~LevelManager();

	void			start();
	void			nextLevel();
	void			reset();
	Level*			getCurrentLevel() const;
	int				getCurrentLevelNumber() const;

private:
	void			createLevels();

	Level		*plevels[LEVELCOUNT];
	int			current;
};

#endif

