#include <string.h>
#include "vector3d.h"
#include "matrix4x4.h"

/*
elements:

	|  0  1  2  3 |
	|  4  5  6  7 |
	|  8  9 10 11 |
	| 12 13 14 15 |

*/

Matrix4x4::Matrix4x4()
{
	memset(m, 0, sizeof(GLfloat[16]));
}

Vector3D Matrix4x4::operator*(const Vector3D& v)
{
	Vector3D result;

	result.x = m[0]*v.x + m[1]*v.y + m[2]*v.z + m[3]*1;
	result.y = m[4]*v.x + m[5]*v.y + m[6]*v.z + m[7]*1;
	result.z = m[8]*v.x + m[9]*v.y + m[10]*v.z + m[11]*1;

	return result;
}

Matrix4x4 Matrix4x4::operator*(const Matrix4x4& b)
{
	Matrix4x4	c;
	c.m[0] = m[0]*b.m[0] + m[1]*b.m[4] + m[2]*b.m[8] + m[3]*b.m[12];
	c.m[1] = m[0]*b.m[1] + m[1]*b.m[5] + m[2]*b.m[9] + m[3]*b.m[13];
	c.m[2] = m[0]*b.m[2] + m[1]*b.m[6] + m[2]*b.m[10] + m[3]*b.m[14];
	c.m[3] = m[0]*b.m[3] + m[1]*b.m[7] + m[2]*b.m[11] + m[3]*b.m[15];
	c.m[4] = m[4]*b.m[0] + m[5]*b.m[4] + m[6]*b.m[8] + m[7]*b.m[12];
	c.m[5] = m[4]*b.m[1] + m[5]*b.m[5] + m[6]*b.m[9] + m[7]*b.m[13];
	c.m[6] = m[4]*b.m[2] + m[5]*b.m[6] + m[6]*b.m[10] + m[7]*b.m[14];
	c.m[7] = m[4]*b.m[3] + m[5]*b.m[7] + m[6]*b.m[11] + m[7]*b.m[15];
	c.m[8] = m[8]*b.m[0] + m[9]*b.m[4] + m[10]*b.m[8] + m[11]*b.m[12];
	c.m[9] = m[8]*b.m[1] + m[9]*b.m[5] + m[10]*b.m[9] + m[11]*b.m[13];
	c.m[10] = m[8]*b.m[2] + m[9]*b.m[6] + m[10]*b.m[10] + m[11]*b.m[14];
	c.m[11] = m[8]*b.m[3] + m[9]*b.m[7] + m[10]*b.m[11] + m[11]*b.m[15];
	c.m[12] = m[12]*b.m[0] + m[13]*b.m[4] + m[14]*b.m[8] + m[15]*b.m[12];
	c.m[13] = m[12]*b.m[1] + m[13]*b.m[5] + m[14]*b.m[9] + m[15]*b.m[13];
	c.m[14] = m[12]*b.m[2] + m[13]*b.m[6] + m[14]*b.m[10] + m[15]*b.m[14];
	c.m[15] = m[12]*b.m[3] + m[13]*b.m[7] + m[14]*b.m[11] + m[15]*b.m[15];

	return c;
}
