/** @file menuitem.h
  * @brief MenuItem declaration.
  */

#ifndef menuitem_include
#define menuitem_include

#include <vector>
#include <string>

/** @brief A simple rectangle representation.
  *
  * Currently only used by the menu system.
  */
typedef struct
{
	int top;
	int left;
	int bottom;
	int right;
} RECT;

/** @brief A menu item.
  *
  * Everything on a menu screen, like text, clickable items or 3d objects, is
  * a menu item. This class manages their position in a resolution-independent
  * manner.
  *
  * @todo text colors
  */
class MenuItem  
{
public:
	/*constructor*/		MenuItem(const char* text, float xmult, float ymult, int xoffs, int yoffs, bool selectable);
	/*destructor*/		virtual ~MenuItem();
	void				calcRect();
	void				setToggleValues(const char** vals, int num);
	void				setToggleSelection(const char*);
	void				setToggleSelection(int);
	const char*			getToggleValue() const {return values[togsel].c_str();}
	void				toggleForward();
	void				toggleBackward();
	inline RECT			getRect() const { return rect; }
	inline int			getPosX() const { return posx; }
	inline int			getPosY() const { return posy; }
	inline const char*	getText() const { return text.c_str(); }
	inline bool			isSelectable() const { return selectable; }
	inline bool			isToggle() const { return toggle; }

private:
	const char*     textbase;
	std::string     text;

	/// Multiplier for window width.
	float						xmult;

	/// Multiplier for window height.
	float						ymult;

	/// X offset in screen pixels. Applied after multiplication.
	int							xoffs;

	/// Y offset in screen pixels. Applied after multiplication.
	int							yoffs;

	/// Calculated internal value. posx = (window width * xmult) + xoffs
	int							posx;

	/// Calculated internal value. posx = (window height * ymult) + yoffs
	int							posy;

	/// The surrounding selection rectangle.
	RECT						rect;
	bool						selectable;
	std::vector<std::string>	values;
	bool						toggle;	// true if this item is a toggle
	unsigned int				togsel;	// currently selected toggle item
};

#endif // ndef __MENUITEM_H__
