#include "stdinclu.h"
#include "constants.h"
#include "vector3d.h"
#include "spaceobject.h"
#include "missile.h"

Missile::Missile()
{
	bActive = false;
}

/* Moves the missile, following its pTarget.
*/
bool Missile::move(int timediff)
{
	age += timediff;
	if ( age > MISSILE_MAX_AGE )
		return false;
	
	float		m[16];
	Vector3D	vt = pTarget->getPosition() - position,
				axis = CrossProduct(vt, lookdir);
	vt.normalize();

	glPushMatrix();
 		m[ 0] = right.x; m[ 1] = up.x; m[ 2] = lookdir.x; m[ 3] = 0.0f;
		m[ 4] = right.y; m[ 5] = up.y; m[ 6] = lookdir.y; m[ 7] = 0.0f;
		m[ 8] = right.z; m[ 9] = up.z; m[10] = lookdir.z; m[11] = 0.0f;
		m[12] = 0;		 m[13] = 0;	   m[14] = 0;		  m[15] = 1.0f;
		glLoadMatrixf(m);
		glRotatef(MISSILE_TURN_SPEED*timediff, axis.x, axis.y, axis.z);
		glGetFloatv(GL_MODELVIEW_MATRIX, m);
		glFlush();

		right.x = m[0];right.y = m[4];right.z=m[8];
		up.x = m[1];	up.y = m[5];	up.z = m[9];
		lookdir.x = m[2]; lookdir.y = m[6]; lookdir.z = m[10];
		
		right.normalize();
		up.normalize();
		lookdir.normalize();
	glPopMatrix();

	position = position + (lookdir*(float)timediff*MISSILE_VELOCITY);

	return true;
}

void Missile::start(SpaceObject *parent, SpaceObject *target, int iModel)
{
	position = parent->getPosition();
	lookdir = parent->getLookDir();
	right = parent->getRight();
	up = parent->getUp();

	position = position + lookdir * MISSILE_DISPLACEMENT;	// prevent this missile from hitting its parent ship

	rotation.m[ 0] = right.x;	rotation.m[ 4] = right.y;	rotation.m[ 8] = right.z;
	rotation.m[ 1] = up.x;		rotation.m[ 5] = up.y;		rotation.m[ 9] = up.z;
	rotation.m[ 2] = lookdir.x;	rotation.m[ 6] = lookdir.y;	rotation.m[10] = lookdir.z;
	rotation.m[15] = 1;

	bActive = true;
	model = iModel;
	pTarget = target;
	age = 0;
}

void Missile::draw()
{
	float		m[16];

	glTranslated(position.x, position.y, position.z);

	m[ 0] = right.x; m[ 4] = up.x; m[ 8] = lookdir.x; m[12] = 0.0f;
	m[ 1] = right.y; m[ 5] = up.y; m[ 9] = lookdir.y; m[13] = 0.0f;
	m[ 2] = right.z; m[ 6] = up.z; m[10] = lookdir.z; m[14] = 0.0f;
	m[ 3] = 0;		 m[ 7] = 0;	   m[11] = 0;		  m[15] = 1.0f;
	glMultMatrixf(m);

	glCallList(model);
}

