/** @file missile.h
  * @brief Missile declaration.
  */

#ifndef missile_include
#define missile_include

#include "vector3d.h"
#include "matrix4x4.h"

class SpaceObject;

/** @brief A missile with its own little AI.
  *
  * @todo See Bullet. Missile may also be subject to be changed into a space
  * object with its own ShipAI-derived AI.
  */
class Missile
{
public:
	/*constructor*/			Missile();
	bool					move(int timediff);
	inline Vector3D			getPosition() const { return position; };
	inline int				getModel() const { return model; };
	inline bool				isActive() const { return bActive; };
	inline void				stop() { bActive = false; };
	void					start(SpaceObject *parent, SpaceObject *target, int iModel);
	void					draw();

protected:
	Vector3D				position,
							lookdir,
							right,
							up;
	Matrix4x4				rotation;	// like a copy of lookdir, right and up vectors
	bool					bActive;
	int						model;
	int						age;
	SpaceObject				*pTarget;
};

#endif
