#ifdef _MSC_VER
#	include <windows.h>
#endif

#include <GL/glut.h>
#include <iostream>
#include <stdio.h>
#include "nshmodel.h"

using namespace std;

NSHModel	model;
bool		lmb_down, rmb_down,		// state of the mouse buttons
			wireframe = false,		// draw model wire frame
			bgblack = true,			// use black or alternate bg color
			lighting = true,		// use lighting on the model
			smooth = true;			// use the smoothed surface normals
int			x, y, ox, oy,
			xrot=0, yrot=0;
GLdouble	zpos = -500, oz;
GLfloat light_position[] = { 500.0, 500.0, 1000.0, 0.0 };

void init()
{
	GLfloat		lightpos[4] =		{100, 0, 150, 1.0f};
	GLfloat		ambientLight[4] =	{0.3f, 0.3f, 0.3f, 1.0f};
	GLfloat		diffuseLight[4] =	{0.7f, 0.7f, 0.7f, 1.0f};
	GLfloat		specular[4] =		{1, 1, 1, 1};
	GLfloat		specreflect[4] =	{1, 1, 1, 1};

	glClearColor(0, 0, 0, 0);
	glEnable(GL_LIGHTING);		// lighting
	glLightfv(GL_LIGHT0, GL_AMBIENT, ambientLight);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuseLight);
	glLightfv(GL_LIGHT0, GL_SPECULAR, specular);
	glLightfv(GL_LIGHT0, GL_POSITION, lightpos);
	glEnable(GL_LIGHT0);
	glEnable(GL_DEPTH_TEST);	// depth testing
	glEnable(GL_COLOR_MATERIAL);
	glFrontFace(GL_CCW);
	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, specreflect);
	glMateriali(GL_FRONT_AND_BACK, GL_SHININESS, 128);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
/*
	GLfloat diffuseMaterial[4] = { 0.5, 0.5, 0.5, 1.0 };
	GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 1.0 };
	glShadeModel (GL_SMOOTH);
	glEnable(GL_DEPTH_TEST);
	glMaterialfv(GL_FRONT, GL_DIFFUSE, diffuseMaterial);
	glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
	glMaterialf(GL_FRONT, GL_SHININESS, 25.0);
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	glLightfv(GL_LIGHT0, GL_POSITION, light_position);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	
	glColorMaterial(GL_FRONT, GL_DIFFUSE);
	glEnable(GL_COLOR_MATERIAL);*/
}

void display()
{
	glClearDepth(1.0);
	if ( bgblack )
		glClearColor(0.0, 0.0, 0.0, 0.0);
	else
		glClearColor(1.0, 1.0, 1.0, 1.0);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLightfv(GL_LIGHT0, GL_POSITION, light_position);
	glPushMatrix();
		glTranslated( 0, 0, zpos );
		glRotated(xrot, 1, 0, 0);
		glRotated(yrot, 0, 1, 0);
		if (wireframe)
			model.drawWireFrame();
		else
			glCallList(1);
	glPopMatrix();
	glFlush();
	glutSwapBuffers();
}

void reshape (int w, int h)
{
	glViewport (0, 0, (GLsizei) w, (GLsizei) h);
	glMatrixMode (GL_PROJECTION);
	glLoadIdentity();
	GLdouble aspect = (GLdouble) w / (GLdouble) h;
	gluPerspective(45.0, aspect, 1.0, 3000.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glClearColor(0, 0, 0, 0);
	glutPostRedisplay();
}

void keyboard(unsigned char key, int x, int y)
{
	switch (key)
	{
		case 'l': lighting = !lighting; model.createDisplayList(1, lighting, smooth); break;
		case 's': smooth = !smooth; model.createDisplayList(1, lighting, smooth); break;
		case 'b': bgblack = !bgblack; break;
		case 'w': wireframe = !wireframe; break;
		case 27: glDeleteLists(1, 1); exit(0);
	}
	glutPostRedisplay();
}

void mouse(int button, int state, int x, int y)
{
	ox = x;
	oy = y;
	oz = y;
	if (button==GLUT_LEFT_BUTTON)
	{
		if (state==GLUT_DOWN)
			lmb_down = true;
		else
			lmb_down = false;
	}
	if (button==GLUT_RIGHT_BUTTON)
	{
		if (state==GLUT_DOWN)
			rmb_down = true;
		else
			rmb_down = false;
	}
}

void motion(int x, int y)
{
	if (lmb_down)
	{
		yrot += x-ox;
		xrot += y-oy;
		ox = x;
		oy = y;
	}
	if (rmb_down)
	{
		zpos += (GLdouble)(y-oz);
		oz = y;
	}
	glutPostRedisplay();
}

int main(int argc, char **argv)
{
	cout << "NSH model editor/viewer, (c) 2004 Ingmar Frank" << endl;
	cout << "version 0.4, viewing only" << endl;
	if (argc < 2)
	{
		cerr << "usage: " << argv[0] << " <model file name>" << endl;
		return 0;
	}
	if ( model.loadFromFile(argv[1]) == false )
	{
		cerr << "error while loading model file, aborting" << endl;
		return 0;
	}

	glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize (640, 480); 
	glutInitWindowPosition (100, 100);
	char buf[256];
	sprintf(buf, "%s - %s", argv[0], model.getName());
	glutCreateWindow (buf);
	init();
	model.createDisplayList(1, lighting, smooth);
	glutReshapeFunc(reshape);
	glutDisplayFunc(display);
	//glutIdleFunc(idle);
	glutKeyboardFunc(keyboard);
	glutMouseFunc(mouse);
	glutMotionFunc(motion);
	glutMainLoop();

	return 0;
}
