/** @file nwsound.cpp
  */
#include <ClanLib/sound.h>
#include <ClanLib/vorbis.h>
#include "nwsound.h"

NWSound::NWSound()
{
	CL_SetupSound::init();
	CL_SetupVorbis::init();
	output = CL_SoundOutput(44100);
	shot_sample = CL_SoundBuffer("sound/shot.ogg");
	shot_session = shot_sample.prepare();
	explosion_sample = CL_SoundBuffer("sound/explosion.ogg");
	explosion_session = explosion_sample.prepare();
	warning_sample = CL_SoundBuffer("sound/warning.ogg");
	warning_session = warning_sample.prepare();
	hit_sample = CL_SoundBuffer("sound/hit.ogg");
	hit_session = hit_sample.prepare();
	pickup_sample = CL_SoundBuffer("sound/pickup.ogg");
	pickup_session = pickup_sample.prepare();
}

NWSound::~NWSound()
{
	CL_SetupVorbis::deinit();
	CL_SetupSound::deinit();
}

/** @brief Plays the bullet shooting sample.
  */
void NWSound::play_shot()
{
	if ( shot_session.is_playing() )
		shot_session.stop();
	shot_session = shot_sample.prepare();
	shot_session.play();
}

/** @brief Plays the explosion sound.
  */
void NWSound::play_explosion()
{
	if ( shot_session.is_playing() )
		shot_session.stop();	// because NetWars sounds overlap; low freqs!
	explosion_sample.play();
}

/** @brief Plays the warning sound.
  */
void NWSound::play_warning()
{
	if ( warning_session.is_playing() )
		warning_session.stop();
	warning_session = warning_sample.prepare();
	warning_session.play();
}

/** @brief Plays the getting hit sound.
  */
void NWSound::play_hit()
{
	if ( hit_session.is_playing() )
		hit_session.stop();
	hit_session = hit_sample.prepare();
	hit_session.play();
}

/** @brief Plays pick up sound.
  */
void NWSound::play_pickup()
{
	if ( pickup_session.is_playing() )
		pickup_session.stop();
	pickup_session = pickup_sample.prepare();
	pickup_session.play();
}

