/** @file nwsound.h
  */

#ifndef nwsound_include
#define nwsound_include

#include <ClanLib/sound.h>

/** @brief Encapsulates the ClanLib sound library functions.
  *
  * Just construct an object of this class and call the sound playing
  * methods appropriately.
  * 
  * Before construction, the ClanLib core should be initalised.
  */
class NWSound
{
public:
	NWSound();
	~NWSound();

	void play_shot();
	void play_explosion();
	void play_warning();
	void play_hit();
	void play_pickup();

private:
	/// Required by ClanLib.
	CL_SoundOutput output;

	/// The bullet shooting sound.
	CL_SoundBuffer shot_sample;
	/// Manages the shot sound.
	CL_SoundBuffer_Session shot_session;

	/// The explosion sound.
	CL_SoundBuffer explosion_sample;
	/// Manages the explosion sound.
	CL_SoundBuffer_Session explosion_session;

	/// The warning sound.
	CL_SoundBuffer warning_sample;
	/// Manages the warning sound.
	CL_SoundBuffer_Session warning_session;
	
	/// The sound that is heard when the player gets hit by something.
	CL_SoundBuffer hit_sample;
	/// Manages the hit sound.
	CL_SoundBuffer_Session hit_session;

	/// The sound that is heard when the player picks up an extra.
	CL_SoundBuffer pickup_sample;
	/// Manages the pickup sound.
	CL_SoundBuffer_Session pickup_session;
};

#endif // nwsound_include
