#include <GL/glut.h>
#include <stdlib.h>
#include <stdio.h>
#include "stdinclu.h"
#include "constants.h"
#include "nshmodel.h"
#include "vector3d.h"
#include "objects.h"
#include "configuration.h"

//external variables
extern int				giWidth, giHeight, giWidthHalf, giHeightHalf;
extern Configuration	config;

//external functions
void error(const char* msg);

void createNSHModel(GLuint listno, const char* filename)
{
	NSHModel model;

	if ( model.loadFromFile(filename)==false )
	{	
		error("could not load ");
		error(filename); 
		error("\n");
	}
	else
		model.createDisplayList(listno, true, true);
}

void createLogo()
{
	glNewList(DL_LOGO, GL_COMPILE);
		glColor3f(GLGREEN);
		glutSolidSphere(36, 20, 20);
		float f = 1;
		for ( int i=0; i < 5; i+=1, f *= 0.95 )
		{
			glScalef(f, f, f);
			glCallList(DL_CALDERA_C);
		}
	glEndList();
}

void createStarfield()
{
	Vector3D v;
	GLfloat tone;

	glNewList(DL_STARFIELD, GL_COMPILE);
		glPushAttrib(GL_ENABLE_BIT | GL_DEPTH_BUFFER_BIT | GL_LIGHTING_BIT | GL_POLYGON_BIT);
		//glCullFace(GL_FRONT);
		glDisable(GL_DEPTH_TEST);
		glDisable(GL_LIGHTING);
		glPointSize(2.0);
		glEnable(GL_POINT_SMOOTH);
		glBegin(GL_POINTS);
		for (int i=0; i<config.getNumStars(); i++)
		{
			v.x = (rand()%101)-50;
			v.y = (rand()%101)-50;
			v.z = (rand()%101)-50;
			//v.Normalize(); // does not seem to work, depends on the viewport/angle
			tone = ((rand()%10)+1) / 10.0;
			glColor3f(tone, tone, tone);
			glVertex3f(v.x, v.y, v.z);
		}
		glEnd();//points
		glPopAttrib();
	glEndList();
}

void createBullets()
{
	glNewList(DL_BULLET1, GL_COMPILE);
		glPushAttrib(GL_ENABLE_BIT | GL_POINT_BIT | GL_LIGHTING_BIT);
		glDisable(GL_LIGHTING);
		glColor3d(GLWHITE);
		glutSolidSphere(BULLET_RADIUS*0.5, 20, 20);
		glPopAttrib();
	glEndList();
	glNewList(DL_BULLET2, GL_COMPILE);
		glPushAttrib(GL_POINT_BIT | GL_LIGHTING_BIT);
		glDisable(GL_LIGHTING);
		glColor3d(GLYELLOW);
		glutSolidSphere(BULLET_RADIUS*0.5, 20, 20);
		glPopAttrib();
	glEndList();
}

void createParticle()
{
	glNewList(DL_PARTICLE, GL_COMPILE);
		glPushAttrib(GL_POINT_BIT | GL_LIGHTING_BIT);
		glDisable(GL_LIGHTING);
		glPointSize(50);
		//glVertex3f(0, 0, 0);
		glutSolidSphere(PARTICLE_RADIUS, 10, 10);
		glPopAttrib();
	glEndList();
}

void createLockArrows()
{// lock arrows MUST be drawn in ortho mode!
	glNewList(DL_LOCKARROWS, GL_COMPILE);
		glBegin(GL_LINE_STRIP);
			glVertex2f(giWidthHalf-giWidth*0.07, giHeightHalf-giWidth*0.03);
			glVertex2f(giWidthHalf-giWidth*0.03, giHeightHalf-giWidth*0.07);
			glVertex2f(giWidthHalf-giWidth*0.02, giHeightHalf-giWidth*0.02);
			glVertex2f(giWidthHalf-giWidth*0.07, giHeightHalf-giWidth*0.03);
		glEnd();
		glBegin(GL_LINE_STRIP);
			glVertex2f(giWidthHalf-giWidth*0.07, giHeightHalf+giWidth*0.03);
			glVertex2f(giWidthHalf-giWidth*0.03, giHeightHalf+giWidth*0.07);
			glVertex2f(giWidthHalf-giWidth*0.02, giHeightHalf+giWidth*0.02);
			glVertex2f(giWidthHalf-giWidth*0.07, giHeightHalf+giWidth*0.03);
		glEnd();
		glBegin(GL_LINE_STRIP);
			glVertex2f(giWidthHalf+giWidth*0.07, giHeightHalf-giWidth*0.03);
			glVertex2f(giWidthHalf+giWidth*0.03, giHeightHalf-giWidth*0.07);
			glVertex2f(giWidthHalf+giWidth*0.02, giHeightHalf-giWidth*0.02);
			glVertex2f(giWidthHalf+giWidth*0.07, giHeightHalf-giWidth*0.03);
		glEnd();
		glBegin(GL_LINE_STRIP);
			glVertex2f(giWidthHalf+giWidth*0.07, giHeightHalf+giWidth*0.03);
			glVertex2f(giWidthHalf+giWidth*0.03, giHeightHalf+giWidth*0.07);
			glVertex2f(giWidthHalf+giWidth*0.02, giHeightHalf+giWidth*0.02);
			glVertex2f(giWidthHalf+giWidth*0.07, giHeightHalf+giWidth*0.03);
		glEnd();
	glEndList();
}

void createRadarGrid()
{// draws a grid (center point = 0,0,0) in the xy-plane
	glNewList(DL_RADARGRID, GL_COMPILE);
	glBegin(GL_LINES);
	for (int i=-2; i<=2; i++)
	{
		glVertex2f( i*50, -100 ); glVertex2f( i*50, 100 );
		glVertex2f( -100, i*50 ); glVertex2f( 100, i*50 );
	}
	glEnd();// lines
	glEndList();
}

void createObjects()
{
	createNSHModel(DL_HEALTH,    NSHFILE_HEALTH);
	createNSHModel(DL_FIREPOWER, NSHFILE_FIREPOWER);
	createNSHModel(DL_THRUST,    NSHFILE_THRUST);
	createNSHModel(DL_XTRAMSSL,  NSHFILE_XTRAMSSL);
	createNSHModel(DL_CLOAK,     NSHFILE_CLOAK);
	createNSHModel(DL_MISSILE,   NSHFILE_MISSILE);
	createNSHModel(DL_POD,       NSHFILE_POD);
	createNSHModel(DL_PIRATE,    NSHFILE_PIRATE);
	createNSHModel(DL_FIGHTER,   NSHFILE_FIGHTER);
	createNSHModel(DL_GUARDIAN,  NSHFILE_GUARDIAN);
	createNSHModel(DL_COMMANDER, NSHFILE_COMMANDER);
	createNSHModel(DL_TITLE,     NSHFILE_TITLE);
	createNSHModel(DL_CALDERA_C, NSHFILE_CALDERA_C);
	createNSHModel(DL_LOGO,      NSHFILE_LOGO);
	//createLogo();
	createStarfield();
	createBullets();
	createParticle();
	createLockArrows();
	createRadarGrid();
}

