#include <string.h>
#include "particle.h"

Particle::Particle()
{
	position = Vector3D(0, 0, 0);
	direction = Vector3D(0, 0, 0);
	velocity = acceleration = 0;
}

Particle::Particle(const Vector3D& vpos, const Vector3D& vdir, 
				   GLfloat fVelocity, GLfloat fAccel, GLdouble aColor[3])
	: position(vpos), 
	  direction(vdir),
	  velocity(fVelocity), 
	  acceleration(fAccel)
{
	memcpy(color, aColor, sizeof(color));
}

void Particle::move(int timediff)
{
	position = position + (direction*(velocity*timediff));
	velocity = velocity + (acceleration*timediff);
}
