/** @file particle.h
  * @brief Particle declaration.
  */

#ifndef particle_include
#define particle_include

#include "vector3d.h"

/** @brief Manages a particle that is part of a ParticleSystem.
  *
  * A particle is a simple 3d object with some values for controlling its
  * movement.
  */
class Particle
{
public:
	/*constructor*/		Particle();
	/*constructor*/		Particle(const Vector3D& vpos, const Vector3D& vdir, GLfloat fVelocity, GLfloat fAccel, GLdouble aColor[3]);
	void				move(int timediff);
	Vector3D			position,	///< The particle's position.
						direction;	///< Flying direction.
	GLfloat				velocity,	///< Current velocity.
						acceleration;	///< The acceleration, applied every move().
	GLdouble			color[3];	///< The particle's color.
};

#endif
