/** @file particlesystem.h
  * @brief ParticleSystem declaration.
  */

#ifndef particlesystem_include
#define particlesystem_include

#include <list>
#include "constants.h"
#include "particle.h"

/** @brief Manages a number of Particle objects.
  *
  * Currently the constructors are written in a way that a ParticleSystem
  * can be used easily for explosions.
  */
class ParticleSystem
{
public:
	/*constructor*/		ParticleSystem();
	/*constructor*/		ParticleSystem(const Vector3D& vpos, int nParticleCount);
	/*destructor*/		~ParticleSystem();
	bool				move(int timediff);
	void				draw();

private:

	/** This list type is used for the particles. List is more efficient than
	  * vector when erasing elements from the middle, which may occur quite 
	  * often here because the particles start out with random velocities.
	  */
	typedef std::list<Particle> ParticleList;

	void				createParticles();

	Vector3D			position;		///< The center of the particle system.
	ParticleList		particles;		///< The particles.
	int					nParticles;		///< Count of particles in this system.
};

#endif
