/** @file pirateai.h
  * @brief PirateAI declaration.
  */

#ifndef pirateai_include
#define pirateai_include

#include "shipai.h"

class SpaceObject;
class Game;
class PodAI;

enum PirateState { ATTACK_PLAYER, FLEE, APPROACH_POD, DOCK_POD, FLEE_POD };

/** @brief Pirate ship AI.
 * 
 * This is the pirate AI implementation.
 * A pirate first targets the player and launches a missile when near enough.
 * Then it targets a pod, docks, and pulls it away until both pirate and pod
 * are destroyed in a certain distance.
 *
 * @todo I just realized how bad the 'communication' is implemented. Sometimes,
 * an AI messages another AI directly, and on other occasions, an AI messages
 * its or another AI's parent SpaceObject. Very inconsistent, and unreadable,
 * too. Lack of design.
 * Update: Maybe ClanLib signals could be used... later.
 */
class PirateAI : public ShipAI
{
	// overridden base class methods
	virtual void		step(int timediff);
public:
						PirateAI(SpaceObject*);	// constructor
	void				notifyPodDestruction(SpaceObject*);
	inline void			setInitialTarget(SpaceObject* pplr) { pTarget = pPlayer = pplr; }
	inline SpaceObject*	getTargetPod() const { return pTargetPod; }
	inline void			setGame(Game* pg) { pGame = pg; }
private:
	void				watchPod();

	PirateState			state;
	SpaceObject*		pTargetPod; ///< The pod that is targeted by the pirate.
	SpaceObject*		pPlayer;
	PodAI*				pTargetAI; ///< The AI of the targeted pod.

	/// For how long the pirate is already fleeing with the pod.
	int					fleeingTime;

	/// Pointer to the game space in which this AI exists.
	Game*				pGame;
};

#endif

