#include <stdlib.h>
#include "stdinclu.h"
#include "constants.h"
#include "shipai.h"
#include "spaceobject.h"
#include "podai.h"
#include "game.h"

PodAI::PodAI(SpaceObject* pprnt)
{
	pParent = pprnt;
	initpos = pprnt->getPosition();
	pParent->setAutoRotation(POD_AUTOROTATION);
	state = IDLE;
	pTarget = NULL; 
	maxvelocity = PIRATE_MAX_VELOCITY;	// should have the same characteristics
	velocity = 0;
	turnspeed = 3*PIRATE_TURN_SPEED; // because of docking problems
}

void PodAI::dock(SpaceObject* pHijacker)
{
	pTarget = pHijacker;
	pParent->setAutoRotation(0, 0, 0);
	state = BEING_DOCKED;
}

/** Begin the hijacking (follow the bad guy). */
void PodAI::hijack()
{
	velocity = 100;
	state = BEING_HIJACKED;
}

/** set the pod free again (returns to initial position). */
void PodAI::setFree()
{
	velocity = POD_RETURN_VELOCITY;
	state = COMING_BACK;
}

void PodAI::step(int timediff)
{
	static Vector3D distance;
	switch (state)
	{
		case IDLE:
			break;
		case BEING_DOCKED:
			trackTarget(timediff);
			break;
		case BEING_HIJACKED:
			trackTarget(timediff);
			break;
		case COMING_BACK:
			moveToTarget(initpos, timediff);
			distance = pParent->getPosition() - initpos;
			if ( distance.getLength() < POD_POSITION_TOLERANCE )
			{
				pParent->setAutoRotation(POD_AUTOROTATION);
				state = IDLE;
			}
			break;
	}
}

