/** @file podai.h
  * @brief PodAI declaration.
  */

#ifndef podai_include
#define podai_include

#include "shipai.h"

enum PodState { IDLE, BEING_DOCKED, BEING_HIJACKED, COMING_BACK }; 

/** @brief Pod AI.
  *
  * A pod sits in space. If it gets docked by a pirate, it will 'follow' the
  * pirate (it is being hijacked). If the pirate ship gets destroyed before it
  * can destroy the pod, the pod returns to its original position.
  */
class PodAI : public ShipAI
{
	// overridden base class methods
	virtual void		step(int timediff);
public:
						PodAI(SpaceObject*);	// constructor
	void				dock(SpaceObject*);
	void				hijack();
	void				setFree();
	inline bool			isBeingHijacked() const { return ((state==BEING_HIJACKED) || (state==BEING_DOCKED)); }
private:
	Vector3D			initpos; ///< Initial position.
	PodState			state;
};

#endif
