#include "stdinclu.h"
#include "constants.h"
#include "vector3d.h"
#include "shipai.h"
#include "spaceobject.h"

/**
 * @brief Move towards the target position.
 *
 * This includes turning to face the target.
 * @param target The target position.
 * @param timediff The time difference since the last step.
 */
void ShipAI::moveToTarget(Vector3D target, int timediff)
{
	float		m[16];
	Vector3D	position = pParent->getPosition(),
				right = pParent->getRight(),
				up = pParent->getUp(),
				lookdir = pParent->getLookDir(),
				vt = target - position,
				axis = CrossProduct(vt, pParent->getLookDir());
	vt.normalize();

	glPushMatrix();
 		m[ 0] = right.x; m[ 1] = up.x; m[ 2] = lookdir.x; m[ 3] = 0.0f;
		m[ 4] = right.y; m[ 5] = up.y; m[ 6] = lookdir.y; m[ 7] = 0.0f;
		m[ 8] = right.z; m[ 9] = up.z; m[10] = lookdir.z; m[11] = 0.0f;
		m[12] = 0;		 m[13] = 0;	   m[14] = 0;		  m[15] = 1.0f;
		glLoadMatrixf(m);
		glRotatef(turnspeed*timediff, axis.x, axis.y, axis.z);
		glGetFloatv(GL_MODELVIEW_MATRIX, m);
		glFlush();

		right.x = m[0];right.y = m[4];right.z=m[8];
		up.x = m[1];	up.y = m[5];	up.z = m[9];
		lookdir.x = m[2]; lookdir.y = m[6]; lookdir.z = m[10];
		
		right.normalize();
		up.normalize();
		lookdir.normalize();
	glPopMatrix();

	position = position + (lookdir*(float)timediff*(velocity*maxvelocity*0.01));

	pParent->setPosition(position);
	pParent->setOrientationVectors(lookdir, right, up);
}

/** @brief Track the target pointed to by pTarget.
  *
  * Currently simply calls moveToTarget() accordingly.
  * @param timediff Time difference since the last step.
  */
void ShipAI::trackTarget(int timediff)
{
	moveToTarget(pTarget->getPosition(), timediff);
}

