/** @file shipai.h
  * @brief ShipAI declaration.
  */

#ifndef shipai_include
#define shipai_include

#include "vector3d.h"

class SpaceObject;

/** @brief The abstract base class for all AI ships.
  *
  * It implements all operations common to AI driven space ships.
  */
class ShipAI
{
public:
						ShipAI() {};
	virtual void		step(int tickcount)=0;
	inline void			setTargetPosition(const Vector3D& v) { targetPos = v; }
	inline SpaceObject*	getTarget() const { return pTarget; }
	inline void			setTarget(SpaceObject* obj) { pTarget = obj; }
protected:
	void				moveToTarget(Vector3D target, int timediff);
	void				trackTarget(int);

	/// The current velocity (as percentage of #maxvelocity).
	int					velocity;

	/// Maximum velocity of this AI's ship.
	float				maxvelocity;

	/// Turning velocity of this AI's ship.
	float				turnspeed;

	/// An arbitrary target position.
	Vector3D			targetPos;

	/// The parent space object that this AI controls.
	SpaceObject*		pParent;
	
	/// This AI's current target object.
	SpaceObject*		pTarget;
};

#endif

