/** @file stdinclu.h
  * @brief Enums, constants, ... 
  * @todo Move all this to constants.h.
  */

#ifndef stdinclud_include
#define stdinclud_include

// enum types
enum EventType {	SPAWN_POWERUP, 
					SPAWN_AISHIP 
				};

enum EventPosType {	ABSOLUTE_POS, 
					PLAYER_LEFT,
					PLAYER_RIGHT,
					PLAYER_FRONT,
					PLAYER_BACK,
					PLAYER_TOP,
					PLAYER_BOTTOM,
					EVENTPOS_TYPE_COUNT 
					};

enum PowerUpType {	HEALTH,
					THRUST,
					FIREPOWER,
					MISSILES,
					CLOAK,
					POD,
					POWERUP_TYPE_COUNT
				}; 

/** @brief AI ship types.
  *
  * These can be added to a SpaceObject to have it controlled by the AI.
  */
enum AIShipType {	NO_AI,
					POD_AI,		///< Fuel pod behaviour.
					PIRATE,		///< Pirate ship behaviour.
					FIGHTER,	///< Fighter ship behaviour.
					GUARDIAN,	///< Guardian ship behaviour.
					COMMANDER,	///< Commander ship behaviour.
					AI_TYPE_COUNT
				};

const int maxAICount = 4;

const EventPosType EventPosOrder[] = {	PLAYER_RIGHT,
										PLAYER_LEFT,
										PLAYER_BOTTOM,
										PLAYER_TOP,
										EVENTPOS_TYPE_COUNT
									};

const PowerUpType PowerUpOrder[] = {	FIREPOWER,
										HEALTH,
										MISSILES,
										THRUST,
										POWERUP_TYPE_COUNT
									};

/////// OpenGl display lists
#define DL_HEALTH		1
#define DL_POD			2
#define DL_PARTICLE		3
#define DL_TITLE		4
#define DL_LOGO			5
#define DL_BULLET1		6
#define DL_BULLET2		7
#define DL_STARFIELD	8
#define DL_CLOAK		9
#define DL_FIREPOWER	10
#define DL_NSH_TIE		11
#define DL_NSH_AWING	12
#define DL_LOCKARROWS	13
#define DL_THRUST		14
#define DL_XTRAMSSL		15
#define DL_MISSILE		16
#define DL_PIRATE		17
#define DL_FIGHTER		18
#define DL_GUARDIAN		19
#define DL_COMMANDER	20
#define DL_RADARGRID	21
#define DL_CALDERA_C	22
// update LISTCOUNT every time when inserting a new ID here!
#define LISTCOUNT		22

#endif
