#include <GL/glut.h>
#include <string.h>
#include "text.h"

/** @brief Returns the pixel width of a text.
  *
  * Currently, only one font is used everywhere, so the only thing you need
  * now is your text.
  * @param string The text of which you want to know the width in pixels.
  * @returns The width of the text in pixels.
  */
int Text::getTextWidth(const char* string)
{
	return glutBitmapLength(GLUT_BITMAP_8_BY_13, (unsigned char*)string);
}

/** @brief Returns the height of the text.
  *
  * Currently, only one font is used everywhere.
  * @returns The height of text strings to print with printTextAt().
  *				Currently 14 constant.
  */
int Text::getTextHeight()
{
	return 14;	// TODO: preliminary, only for 8by13 glut font
}

/** @brief Prints a text on the screen using a GLUT font.
  *
  * Currently, only one font is used everywhere. Text is printed left-aligned.
  * @param x X coordinate of the text position.
  * @param y Y coordinate of the text position.
  * @param string Pointer to the text to be printed.
  */
void Text::printAt(float x, float y, const char *string)
{
	int len, i;

	glRasterPos2f(x, y);
	len = (int) strlen(string);
	for (i = 0; i < len; i++) 
		glutBitmapCharacter(GLUT_BITMAP_8_BY_13, string[i]);
}

/** @brief Prints a centered text on the screen.
  *
  * Uses printAt().
  * Currently, only one font is used everywhere. Text is printed centered.
  * @param x X coordinate of the text center position.
  * @param y Y coordinate of the text position.
  * @param string Pointer to the text to be printed.
  */
void Text::printCenteredAt(float x, float y, const char *string)
{
	printAt( x-(getTextWidth(string)/2), y, string);
}

