#ifdef _MSC_VER
#include <windows.h>
#include <stdio.h>
#include "timing.h"

static LARGE_INTEGER freq; // counts per second
static LARGE_INTEGER startcount;
static LARGE_INTEGER count;

void initTimer()
{
	QueryPerformanceFrequency(&freq);
	if (freq.QuadPart==0)
	{
		fprintf(stderr, "Your system does not support a high-resolution performance counter.\n");
		exit(EXIT_SUCCESS);
	}
	QueryPerformanceCounter(&startcount);
}

int getElapsedTime()
{
	QueryPerformanceCounter(&count);
	return (int) ((count.QuadPart-startcount.QuadPart) / (freq.QuadPart/1000));
}

#endif
