#include <math.h>
#include "vector3d.h"

Vector3D::Vector3D()
{
	x = y = z = 0.0f; 
}

Vector3D::Vector3D(GLfloat nx, GLfloat ny, GLfloat nz)
{
	x = nx;
	y = ny;
	z = nz;
}

GLfloat Vector3D::getLength()
{
	return (GLfloat)sqrt(x*x + y*y + z*z);
}

void Vector3D::normalize()
{
	GLfloat len = getLength();
	if (len==0)
		len = 1.0f;
	x /= len;
	y /= len;
	z /= len;
}

Vector3D Vector3D::operator+(const Vector3D& v)
{
	return Vector3D(v.x+x, v.y+y, v.z+z);
}

Vector3D Vector3D::operator-(const Vector3D& v)
{
	return Vector3D(x-v.x, y-v.y, z-v.z);
}

Vector3D Vector3D::operator*(const Vector3D& v)
{
	return Vector3D(x*v.x, y*v.y, z*v.z);
}

Vector3D Vector3D::operator*(const GLfloat scalar)
{
	return Vector3D(x*scalar, y*scalar, z*scalar);
}

Vector3D& Vector3D::operator-()
{
	x = -x;
	y = -y;
	z = -z;
	return *this;
}

Vector3D& Vector3D::operator=(const Vector3D& v)
{
	x = v.x;
	y = v.y;
	z = v.z;
	return *this;
}

Vector3D CrossProduct(const Vector3D& a, const Vector3D& b)
{
	Vector3D ret;
	ret.x = a.y*b.z - a.z*b.y;
	ret.y = a.z*b.x - a.x*b.z;
	ret.z = a.x*b.y - a.y*b.x;

	return ret;
}

GLfloat DotProduct(const Vector3D& a, const Vector3D& b)
{
	return a.x*b.x + a.y*b.y + a.z*b.z;
}
