/** @file vector3d.h
  * @brief Vector3D declaration.
  */

#ifndef vector3d_include
#define vector3d_include

#include <GL/glut.h>

#define VX	0
#define VY	1
#define VZ	2

class Vector3D
{
public:
	GLfloat				x, y, z;
	/*constructor*/		Vector3D();
	/*constructor*/		Vector3D(GLfloat x, GLfloat y, GLfloat z); 

	/** @brief Constructs a Vector3D from an array of arbitrary type.
	  */
	template<typename T>
	Vector3D(T f[3])
	{
		x = f[0];
		y = f[1];
		z = f[2];
	}

	GLfloat				getLength();
	void				normalize();

	Vector3D		operator+(const Vector3D& v);
	Vector3D		operator-(const Vector3D& v);
	Vector3D		operator*(const Vector3D& v);
	Vector3D		operator*(const GLfloat scalar);
	Vector3D&		operator-();
	Vector3D&		operator=(const Vector3D& v);
};

Vector3D CrossProduct(const Vector3D& a, const Vector3D& b);
GLfloat DotProduct(const Vector3D& a, const Vector3D& b);

#endif

